/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.javazilla.bukkitfabric.BukkitLogger;
import com.javazilla.bukkitfabric.interfaces.IMixinEntity;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.DataConverters_Cardboard_1_17;
import com.sk89q.worldedit.bukkit.adapter.impl.WorldNativeAccess_Cardboard_1_17;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.ByteArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.ByteBinaryTag;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.DoubleBinaryTag;
import com.sk89q.worldedit.util.nbt.EndBinaryTag;
import com.sk89q.worldedit.util.nbt.FloatBinaryTag;
import com.sk89q.worldedit.util.nbt.IntArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.IntBinaryTag;
import com.sk89q.worldedit.util.nbt.ListBinaryTag;
import com.sk89q.worldedit.util.nbt.LongArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.LongBinaryTag;
import com.sk89q.worldedit.util.nbt.ShortBinaryTag;
import com.sk89q.worldedit.util.nbt.StringBinaryTag;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.item.ItemType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2663;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.cardboardpowered.impl.entity.PlayerImpl;
import org.cardboardpowered.impl.world.WorldImpl;

public class Spigot_Cardboard
implements BukkitImplAdapter {
    private final Field nbtListTagListField;
    private static final Set<SideEffect> SUPPORTED_SIDE_EFFECTS = Sets.immutableEnumSet((Enum)SideEffect.NEIGHBORS, (Enum[])new SideEffect[]{SideEffect.LIGHTING, SideEffect.VALIDATION, SideEffect.ENTITY_AI, SideEffect.EVENTS, SideEffect.UPDATE});

    public Spigot_Cardboard() throws NoSuchFieldException, NoSuchMethodException {
        BukkitLogger.getPluginLogger((String)"WorldEdit").info("Init WorldEdit Adapter: Spigot_Cardboard_1_17_1 for WorldEdit 7.3+");
        Field nbtList = null;
        try {
            nbtList = class_2499.class.getDeclaredField("field_11550");
            nbtList.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.nbtListTagListField = nbtList;
    }

    public ItemStack adapt(BaseItemStack item) {
        class_1799 stack = new class_1799((class_1935)class_2378.field_11142.method_10223(class_2960.method_12829((String)item.getType().getId())), item.getAmount());
        stack.method_7980((class_2487)this.fromNative((BinaryTag)item.getNbt()));
        return CraftItemStack.asCraftMirror((class_1799)stack);
    }

    public BaseItemStack adapt(ItemStack itemStack) {
        class_1799 nmsStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        BaseItemStack weStack = new BaseItemStack(BukkitAdapter.asItemType((Material)itemStack.getType()), itemStack.getAmount());
        weStack.setNbt((CompoundBinaryTag)this.toNative((class_2520)nmsStack.method_7969()));
        return weStack;
    }

    public boolean canPlaceAt(World world, BlockVector3 position, BlockState blockState) {
        int internalId = BlockStateIdAccess.getBlockStateId((BlockState)blockState);
        class_2680 blockData = class_2248.method_9531((int)internalId);
        return blockData.method_26167((class_1922)((WorldImpl)world).getHandle(), new class_2338(position.getX(), position.getY(), position.getZ()));
    }

    public Entity createEntity(Location location, BaseEntity state) {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)state);
        WorldImpl craftWorld = (WorldImpl)location.getWorld();
        class_3218 worldServer = craftWorld.getHandle();
        class_1297 createdEntity = Spigot_Cardboard.createEntityFromId(state.getType().getId(), (class_1937)craftWorld.getHandle());
        if (createdEntity != null) {
            CompoundBinaryTag nativeTag = state.getNbt();
            if (nativeTag != null) {
                class_2487 tag = (class_2487)this.fromNative((BinaryTag)nativeTag);
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.method_10551(name);
                }
                Spigot_Cardboard.readTagIntoEntity(tag, createdEntity);
            }
            createdEntity.method_5641(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            worldServer.method_17892(createdEntity);
            return ((IMixinEntity)createdEntity).getBukkitEntity();
        }
        return null;
    }

    class_2520 fromNative(BinaryTag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundBinaryTag) {
            class_2487 tag = new class_2487();
            for (String key : ((CompoundBinaryTag)foreign).keySet()) {
                tag.method_10566(key, this.fromNative(((CompoundBinaryTag)foreign).get(key)));
            }
            return tag;
        }
        if (foreign instanceof ByteBinaryTag) {
            return class_2481.method_23233((byte)((ByteBinaryTag)foreign).value());
        }
        if (foreign instanceof ByteArrayBinaryTag) {
            return new class_2479(((ByteArrayBinaryTag)foreign).value());
        }
        if (foreign instanceof DoubleBinaryTag) {
            return class_2489.method_23241((double)((DoubleBinaryTag)foreign).value());
        }
        if (foreign instanceof FloatBinaryTag) {
            return class_2494.method_23244((float)((FloatBinaryTag)foreign).value());
        }
        if (foreign instanceof IntBinaryTag) {
            return class_2497.method_23247((int)((IntBinaryTag)foreign).value());
        }
        if (foreign instanceof IntArrayBinaryTag) {
            return new class_2495(((IntArrayBinaryTag)foreign).value());
        }
        if (foreign instanceof LongArrayBinaryTag) {
            return new class_2501(((LongArrayBinaryTag)foreign).value());
        }
        if (foreign instanceof ListBinaryTag) {
            class_2499 tag = new class_2499();
            ListBinaryTag foreignList = (ListBinaryTag)foreign;
            for (BinaryTag t : foreignList) {
                tag.add((Object)this.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LongBinaryTag) {
            return class_2503.method_23251((long)((LongBinaryTag)foreign).value());
        }
        if (foreign instanceof ShortBinaryTag) {
            return class_2516.method_23254((short)((ShortBinaryTag)foreign).value());
        }
        if (foreign instanceof StringBinaryTag) {
            return class_2519.method_23256((String)((StringBinaryTag)foreign).value());
        }
        if (foreign instanceof EndBinaryTag) {
            return class_2491.field_21033;
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }

    public WorldNativeAccess<?, ?, ?> createWorldNativeAccess(World world) {
        return new WorldNativeAccess_Cardboard_1_17(this, new WeakReference<class_3218>(((WorldImpl)world).getHandle()));
    }

    public BaseBlock getBlock(Location location) {
        class_2586 te;
        Preconditions.checkNotNull((Object)location);
        WorldImpl craftWorld = (WorldImpl)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        class_3218 handle = craftWorld.getHandle();
        class_2818 chunk = handle.method_8497(x >> 4, z >> 4);
        class_2338 blockPos = new class_2338(x, y, z);
        class_2680 blockData = chunk.method_8320(blockPos);
        int internalId = class_2248.method_9507((class_2680)blockData);
        BlockState state = BlockStateIdAccess.getBlockStateById((int)internalId);
        if (state == null) {
            Block bukkitBlock = location.getBlock();
            state = BukkitAdapter.adapt((BlockData)bukkitBlock.getBlockData());
        }
        if ((te = chunk.method_12201(blockPos, class_2818.class_2819.field_12859)) != null) {
            class_2487 tag = new class_2487();
            Spigot_Cardboard.readTileEntityIntoTag(te, tag);
            return state.toBaseBlock(LazyReference.computed((Object)((CompoundBinaryTag)this.toNative((class_2520)tag))));
        }
        return state.toBaseBlock();
    }

    BinaryTag toNative(class_2520 foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof class_2487) {
            HashMap<String, BinaryTag> values = new HashMap<String, BinaryTag>();
            Set foreignKeys = ((class_2487)foreign).method_10541();
            for (String str : foreignKeys) {
                class_2520 base = ((class_2487)foreign).method_10580(str);
                values.put(str, this.toNative(base));
            }
            return CompoundBinaryTag.from(values);
        }
        if (foreign instanceof class_2481) {
            return ByteBinaryTag.of((byte)((class_2481)foreign).method_10698());
        }
        if (foreign instanceof class_2479) {
            return ByteArrayBinaryTag.of((byte[])((class_2479)foreign).method_10521());
        }
        if (foreign instanceof class_2489) {
            return DoubleBinaryTag.of((double)((class_2489)foreign).method_10697());
        }
        if (foreign instanceof class_2494) {
            return FloatBinaryTag.of((float)((class_2494)foreign).method_10700());
        }
        if (foreign instanceof class_2497) {
            return IntBinaryTag.of((int)((class_2497)foreign).method_10701());
        }
        if (foreign instanceof class_2495) {
            return IntArrayBinaryTag.of((int[])((class_2495)foreign).method_10588());
        }
        if (foreign instanceof class_2501) {
            return LongArrayBinaryTag.of((long[])((class_2501)foreign).method_10615());
        }
        if (foreign instanceof class_2499) {
            try {
                return this.toNativeList((class_2499)foreign);
            }
            catch (Throwable e) {
                return ListBinaryTag.empty();
            }
        }
        if (foreign instanceof class_2503) {
            return LongBinaryTag.of((long)((class_2503)foreign).method_10699());
        }
        if (foreign instanceof class_2516) {
            return ShortBinaryTag.of((short)((class_2516)foreign).method_10696());
        }
        if (foreign instanceof class_2519) {
            return StringBinaryTag.of((String)foreign.method_10714());
        }
        if (foreign instanceof class_2491) {
            return EndBinaryTag.get();
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    private ListBinaryTag toNativeList(class_2499 foreign) throws SecurityException, IllegalArgumentException, IllegalAccessException {
        ListBinaryTag.Builder values = ListBinaryTag.builder();
        List foreignList = (List)this.nbtListTagListField.get(foreign);
        int i = 0;
        while (i < foreign.size()) {
            class_2520 element = (class_2520)foreignList.get(i);
            values.add(this.toNative(element));
            ++i;
        }
        return values.build();
    }

    private static void readTileEntityIntoTag(class_2586 tileEntity, class_2487 tag) {
        tileEntity.method_11007(tag);
    }

    private static void readEntityIntoTag(class_1297 entity, class_2487 tag) {
        entity.method_5647(tag);
    }

    private static class_1297 createEntityFromId(String id, class_1937 world) {
        return class_1299.method_5898((String)id).map(t -> t.method_5883(world)).orElse(null);
    }

    private static void readTagIntoEntity(class_2487 tag, class_1297 entity) {
        entity.method_5651(tag);
    }

    public DataFixer getDataFixer() {
        return DataConverters_Cardboard_1_17.INSTANCE;
    }

    public BaseEntity getEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        CraftEntity craftEntity = (CraftEntity)entity;
        class_1297 mcEntity = craftEntity.getHandle();
        String id = Spigot_Cardboard.getEntityId(mcEntity);
        if (id != null) {
            class_2487 tag = new class_2487();
            Spigot_Cardboard.readEntityIntoTag(mcEntity, tag);
            return new BaseEntity(EntityTypes.get((String)id), LazyReference.computed((Object)((CompoundBinaryTag)this.toNative((class_2520)tag))));
        }
        return null;
    }

    private static String getEntityId(class_1297 entity) {
        class_2960 minecraftkey = class_1299.method_5890((class_1299)entity.method_5864());
        return minecraftkey == null ? null : minecraftkey.toString();
    }

    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        TreeMap properties = Maps.newTreeMap(String::compareTo);
        class_2248 block = Spigot_Cardboard.getBlockFromType(blockType);
        class_2689 blockStateList = block.method_9595();
        for (class_2769 state : blockStateList.method_11659()) {
            BooleanProperty property;
            if (state instanceof class_2746) {
                property = new BooleanProperty(state.method_11899(), (List)ImmutableList.copyOf((Collection)state.method_11898()));
            } else if (state instanceof class_2753) {
                property = new DirectionalProperty(state.method_11899(), state.method_11898().stream().map(e -> Direction.valueOf((String)((class_3542)e).method_15434().toUpperCase())).collect(Collectors.toList()));
            } else if (state instanceof class_2754) {
                property = new EnumProperty(state.method_11899(), state.method_11898().stream().map(e -> ((class_3542)e).method_15434()).collect(Collectors.toList()));
            } else if (state instanceof class_2758) {
                property = new IntegerProperty(state.method_11899(), (List)ImmutableList.copyOf((Collection)state.method_11898()));
            } else {
                throw new IllegalArgumentException("WorldEdit needs an update to support " + state.getClass().getSimpleName());
            }
            properties.put(property.getName(), property);
        }
        return properties;
    }

    private static class_2350 adapt(Direction face) {
        switch (face) {
            case NORTH: {
                return class_2350.field_11043;
            }
            case SOUTH: {
                return class_2350.field_11035;
            }
            case WEST: {
                return class_2350.field_11039;
            }
            case EAST: {
                return class_2350.field_11034;
            }
            case DOWN: {
                return class_2350.field_11033;
            }
        }
        return class_2350.field_11036;
    }

    private static class_2248 getBlockFromType(BlockType blockType) {
        return (class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)blockType.getId()));
    }

    private static class_1792 getItemFromType(ItemType itemType) {
        return (class_1792)class_2378.field_11142.method_10223(class_2960.method_12829((String)itemType.getId()));
    }

    public Component getRichBlockName(BlockType blockType) {
        return TranslatableComponent.of((String)Spigot_Cardboard.getBlockFromType(blockType).method_9539());
    }

    public Component getRichItemName(ItemType itemType) {
        return TranslatableComponent.of((String)Spigot_Cardboard.getItemFromType(itemType).method_7876());
    }

    public Component getRichItemName(BaseItemStack itemStack) {
        return TranslatableComponent.of((String)CraftItemStack.asNMSCopy((ItemStack)BukkitAdapter.adapt((BaseItemStack)itemStack)).method_7922());
    }

    public Set<SideEffect> getSupportedSideEffects() {
        return SUPPORTED_SIDE_EFFECTS;
    }

    public void sendFakeOP(Player player) {
        ((PlayerImpl)player).getHandle().field_13987.method_14364((class_2596)new class_2663((class_1297)((PlayerImpl)player).getHandle(), 28));
    }

    public void sendFakeNBT(Player player, BlockVector3 pos, CompoundBinaryTag nbtData) {
        ((PlayerImpl)player).getHandle().field_13987.method_14364((class_2596)new class_2622(new class_2338(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()), 7, (class_2487)this.fromNative((BinaryTag)nbtData)));
    }

    static void readTagIntoTileEntity(class_2487 tag, class_2586 tileEntity) {
        tileEntity.method_11014(tag);
        tileEntity.method_5431();
    }

    public OptionalInt getInternalBlockStateId(BlockData data) {
        class_2680 state = ((CraftBlockData)data).getState();
        int combinedId = class_2248.method_9507((class_2680)state);
        return combinedId == 0 && state.method_26204() != class_2246.field_10124 ? OptionalInt.empty() : OptionalInt.of(combinedId);
    }

    public OptionalInt getInternalBlockStateId(BlockState state) {
        class_2248 mcBlock = Spigot_Cardboard.getBlockFromType(state.getBlockType());
        class_2680 newState = (class_2680)mcBlock.method_9595().method_11664();
        Map states = state.getStates();
        newState = this.applyProperties((class_2689<class_2248, class_2680>)mcBlock.method_9595(), newState, states);
        int combinedId = class_2248.method_9507((class_2680)newState);
        return combinedId == 0 && state.getBlockType() != BlockTypes.AIR ? OptionalInt.empty() : OptionalInt.of(combinedId);
    }

    private class_2680 applyProperties(class_2689<class_2248, class_2680> stateContainer, class_2680 newState, Map<Property<?>, Object> states) {
        for (Map.Entry<Property<?>, Object> state : states.entrySet()) {
            class_2769 property = stateContainer.method_11663(state.getKey().getName());
            Comparable value = (Comparable)state.getValue();
            if (property instanceof class_2753) {
                Direction dir = (Direction)value;
                value = Spigot_Cardboard.adapt(dir);
            } else if (property instanceof class_2754) {
                String enumName = (String)((Object)value);
                value = (Comparable)((class_2754)property).method_11900((String)((Object)value)).orElseGet(() -> {
                    throw new IllegalStateException("Enum property " + property.method_11899() + " does not contain " + enumName);
                });
            }
            newState = (class_2680)newState.method_11657(property, value);
        }
        return newState;
    }
}

